/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.menu;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.pushingpixels.lafwidget.LafWidgetAdapter;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetSupport;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.Resettable;

public class MenuSearchWidget
extends LafWidgetAdapter<JMenuBar>
implements Resettable {
    private boolean inEvent = false;
    protected PropertyChangeListener propertyListener;
    private SearchPanel searchPanel;

    private static int getMenuItemCount(JMenuItem menuItem) {
        int result = 1;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            int i = 0;
            while (i < menu.getMenuComponentCount()) {
                Component child = menu.getMenuComponent(i);
                if (child instanceof JMenuItem) {
                    result += MenuSearchWidget.getMenuItemCount((JMenuItem)child);
                }
                ++i;
            }
        }
        return result;
    }

    public static int getMenuItemCount(JMenuBar menuBar) {
        int result = 0;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenu menu = menuBar.getMenu(i);
            if (menu != null) {
                result += MenuSearchWidget.getMenuItemCount(menu);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void installUI() {
        final LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
        this.searchPanel = new SearchPanel((JMenuBar)this.jcomp);
        ((JMenuBar)this.jcomp).add((Component)this.searchPanel, ((JMenuBar)this.jcomp).getComponentCount());
        this.searchPanel.setVisible(lafSupport.toInstallMenuSearch((JMenuBar)this.jcomp));
        ((JMenuBar)this.jcomp).addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof JMenu)) {
                    return;
                }
                if (!MenuSearchWidget.this.inEvent) {
                    MenuSearchWidget.this.inEvent = true;
                    Component removed = null;
                    int i = 0;
                    while (i < ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount()) {
                        if (((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i) instanceof SearchPanel) {
                            removed = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i);
                            break;
                        }
                        ++i;
                    }
                    if (removed != null) {
                        ((JMenuBar)MenuSearchWidget.this.jcomp).remove(removed);
                        ((JMenuBar)MenuSearchWidget.this.jcomp).add(removed, ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount());
                        if (lafSupport.toInstallMenuSearch((JMenuBar)MenuSearchWidget.this.jcomp)) {
                            removed.setVisible(true);
                        } else {
                            removed.setVisible(false);
                        }
                    }
                    MenuSearchWidget.this.inEvent = false;
                }
            }
        });
        this.searchPanel.applyComponentOrientation(((JMenuBar)this.jcomp).getComponentOrientation());
    }

    @Override
    public void uninstallUI() {
        ((JMenuBar)this.jcomp).remove(this.searchPanel);
        super.uninstallUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.propertyListener = evt -> {
            if ("componentOrientation".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.searchPanel != null) {
                        this.searchPanel.applyComponentOrientation((ComponentOrientation)evt.getNewValue());
                    }
                    this.reset();
                });
            }
            if ("locale".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> this.reset());
            }
        };
        ((JMenuBar)this.jcomp).addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void uninstallListeners() {
        ((JMenuBar)this.jcomp).removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
    }

    @Override
    public void reset() {
        LafWidgetSupport support = LafWidgetRepository.getRepository().getLafSupport();
        if (this.searchPanel == null) {
            return;
        }
        for (Map.Entry entry : this.searchPanel.resultButtons.entrySet()) {
            int index = (Integer)entry.getKey();
            JButton button = (JButton)entry.getValue();
            Icon markerIcon = support == null ? LafWidgetUtilities.getHexaMarker(index) : support.getNumberIcon(this.searchPanel, index);
            button.setIcon(markerIcon);
        }
        int iconDim = support.getLookupIconSize();
        Icon searchIcon = support == null ? LafWidgetUtilities.getSearchIcon(iconDim, this.searchPanel.getComponentOrientation().isLeftToRight()) : support.getSearchIcon(this.searchPanel, iconDim, this.searchPanel.getComponentOrientation());
        this.searchPanel.searchButton.setIcon(searchIcon);
        ResourceBundle bundle = LafWidgetUtilities.getResourceBundle(this.jcomp);
        this.searchPanel.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
        this.searchPanel.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
    }

    @Override
    public boolean requiresCustomLafSupport() {
        return false;
    }

    private class SearchPanel
    extends JPanel {
        private JToggleButton searchButton;
        private JTextField searchStringField;
        private Map<Integer, JButton> resultButtons;

        public SearchPanel(JMenuBar menuBar) {
            this.setLayout(new SearchResultsLayout(this));
            LafWidgetSupport support = LafWidgetRepository.getRepository().getLafSupport();
            int iconDim = support.getLookupIconSize();
            int buttonDim = support.getLookupButtonSize();
            ComponentOrientation orientation = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentOrientation();
            Icon searchIcon = support == null ? LafWidgetUtilities.getSearchIcon(iconDim, orientation.isLeftToRight()) : support.getSearchIcon(menuBar, iconDim, orientation);
            this.searchButton = new JToggleButton(searchIcon);
            this.searchButton.setPreferredSize(new Dimension(buttonDim, buttonDim));
            ResourceBundle bundle = LafWidgetUtilities.getResourceBundle(menuBar);
            this.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
            this.searchButton.setFocusable(false);
            if (support != null) {
                support.markButtonAsFlat(this.searchButton);
            }
            this.add(this.searchButton);
            this.searchButton.addActionListener(e -> SwingUtilities.invokeLater(() -> {
                boolean toShow = this.searchButton.isSelected();
                this.searchStringField.setVisible(toShow);
                this.searchStringField.requestFocus();
                for (JButton resultButton : this.resultButtons.values()) {
                    resultButton.setVisible(toShow);
                }
                this.repaint();
                this.revalidate();
            }));
            this.searchButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 2) != 0) {
                        SwingUtilities.invokeLater(() -> {
                            SearchPanel.this.removeAll();
                            SearchPanel.this.repaint();
                            ((JMenuBar)MenuSearchWidget.this.jcomp).revalidate();
                        });
                    }
                }
            });
            this.searchStringField = new JTextField();
            this.searchStringField.setColumns(10);
            this.add(this.searchStringField);
            this.searchStringField.setVisible(false);
            this.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
            this.resultButtons = new HashMap<Integer, JButton>();
            this.searchStringField.addActionListener(e -> {
                String searchString = this.searchStringField.getText().toLowerCase();
                if (searchString.trim().length() == 0) {
                    return;
                }
                for (JButton toRemove : this.resultButtons.values()) {
                    this.remove(toRemove);
                }
                this.resultButtons.clear();
                LinkedList<SearchResult> searchResults = this.findOccurences(searchString);
                int count = 0;
                for (SearchResult searchResult : searchResults) {
                    if (count == 16) break;
                    Icon markerIcon = support.getNumberIcon(menuBar, count + 1);
                    JButton resultButton = new JButton(markerIcon);
                    resultButton.addActionListener(new SearchResultListener(searchResult));
                    resultButton.setEnabled(searchResult.isEnabled());
                    this.add(resultButton);
                    this.resultButtons.put(new Integer(count + 1), resultButton);
                    resultButton.setToolTipText("<html><body><b>" + searchResult.toString() + "</b><br>" + LafWidgetUtilities.getResourceBundle(menuBar).getString("Tooltip.menuSearchTooltip") + "</html>");
                    if (support != null) {
                        support.markButtonAsFlat(resultButton);
                    }
                    ++count;
                }
                this.repaint();
                ((JMenuBar)MenuSearchWidget.this.jcomp).revalidate();
            });
        }

        private LinkedList<SearchResult> findOccurences(String searchPattern) {
            LinkedList<SearchResult> result = new LinkedList<SearchResult>();
            LinkedList<JMenu> currentPath = new LinkedList<JMenu>();
            int i = 0;
            while (i < ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount()) {
                Component component = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i);
                if (component instanceof JMenu) {
                    JMenu menu = (JMenu)component;
                    this.checkMenu(currentPath, menu, searchPattern, result);
                }
                ++i;
            }
            return result;
        }

        private void checkMenu(LinkedList<JMenu> currentPath, JMenuItem menuItem, String searchPattern, LinkedList<SearchResult> matchingResults) {
            String menuItemText = menuItem.getText();
            if (menuItemText.toLowerCase().indexOf(searchPattern) >= 0) {
                matchingResults.addLast(new SearchResult((JMenuBar)MenuSearchWidget.this.jcomp, currentPath, menuItem));
            }
            if (menuItem instanceof JMenu) {
                JMenu menu = (JMenu)menuItem;
                currentPath.addLast(menu);
                int i = 0;
                while (i < menu.getMenuComponentCount()) {
                    Component menuComponent = menu.getMenuComponent(i);
                    if (menuComponent instanceof JMenuItem) {
                        JMenuItem childItem = (JMenuItem)menuComponent;
                        this.checkMenu(currentPath, childItem, searchPattern, matchingResults);
                    }
                    ++i;
                }
                currentPath.removeLast();
            }
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            if (aFlag) {
                this.searchStringField.requestFocus();
            }
        }
    }

    private static class SearchResult {
        private MenuElement[] menuElements;

        public SearchResult(JMenuBar menuBar, LinkedList<JMenu> menuPath, JMenuItem menuLeaf) {
            int count = 1;
            if (menuPath != null) {
                count += 2 * menuPath.size();
            }
            if (menuLeaf != null) {
                ++count;
            }
            this.menuElements = new MenuElement[count];
            count = 0;
            this.menuElements[count++] = menuBar;
            if (menuPath != null) {
                for (JMenu menu : menuPath) {
                    this.menuElements[count++] = menu;
                    this.menuElements[count++] = menu.getPopupMenu();
                }
            }
            if (menuLeaf != null) {
                this.menuElements[count] = menuLeaf;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.menuElements != null) {
                String sep = "";
                int i = 0;
                while (i < this.menuElements.length) {
                    MenuElement menuElem = this.menuElements[i];
                    if (menuElem instanceof JMenuItem) {
                        sb.append(sep);
                        sep = " -> ";
                        sb.append(((JMenuItem)menuElem).getText());
                    }
                    ++i;
                }
            }
            return sb.toString();
        }

        public boolean isEnabled() {
            int i = 0;
            while (i < this.menuElements.length) {
                JMenuItem menuItem;
                MenuElement menuElem = this.menuElements[i];
                if (menuElem instanceof JMenuItem && !(menuItem = (JMenuItem)menuElem).isEnabled()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class SearchResultListener
    implements ActionListener {
        private SearchResult searchResult;

        public SearchResultListener(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuElement[] menuElements = this.searchResult.menuElements;
            MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
        }
    }

    private class SearchResultsLayout
    implements LayoutManager {
        private SearchPanel searchPanel;

        public SearchResultsLayout(SearchPanel searchPanel) {
            this.searchPanel = searchPanel;
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            if (this.searchPanel.searchButton.isSelected()) {
                return c.getSize();
            }
            int buttonSize = LafWidgetRepository.getRepository().getLafSupport().getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int buttonSize = LafWidgetRepository.getRepository().getLafSupport().getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        @Override
        public void layoutContainer(Container c) {
            block5: {
                int width;
                int height;
                block4: {
                    height = c.getHeight();
                    width = c.getWidth();
                    if (!this.searchPanel.searchButton.isVisible()) {
                        return;
                    }
                    boolean leftToRight = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentOrientation().isLeftToRight();
                    if (!leftToRight) break block4;
                    int x = 2;
                    int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                    int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                    this.searchPanel.searchButton.setBounds(x, (height - sbHeight) / 2, sbWidth, sbHeight);
                    x += sbWidth + 4;
                    if (!this.searchPanel.isVisible()) break block5;
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x += tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    int i = 1;
                    while (i <= buttonCount) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x, (height - bh) / 2, bw, bh);
                        x += bw + 1;
                        ++i;
                    }
                    break block5;
                }
                int x = width - 2;
                int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                this.searchPanel.searchButton.setBounds(x - sbWidth, (height - sbHeight) / 2, sbWidth, sbHeight);
                x -= sbWidth + 4;
                if (this.searchPanel.isVisible()) {
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x - tbWidth, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x -= tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    int i = 1;
                    while (i <= buttonCount) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x - bw, (height - bh) / 2, bw, bh);
                        x -= bw + 1;
                        ++i;
                    }
                }
            }
        }
    }
}

